# Register Moodle with Azure using Windows PowerShell

This PowerShell Script provisions a new Azure application for your Microsoft 365 tenant, which will be used by the [Microsoft 365 Moodle Plugin](https://github.com/Microsoft/o365-moodle/). The script will provision the app for your O365 tenant, set up all the required Reply URLs and Permissions for the provisioned app and return the AppID and Key. You can use the generated AppID and Key in your O365 Moodle Plugin Setup Page to configure your Moodle server with Azure AD.

## Requirements

* This script requires a Windows 7+ device. MacOS/Linux devices are *NOT* supported.
* This script is only compatible with Windows Powershell 5, which is pre-installed on each Windows 7+ device. Powershell 6+ is *NOT* supported.

## Step-by-Step Instructions

### 1. Prepare the PowerShell script from the ZIP file

* Download and extract the `Moodle-AzureAD-Powershell.zip` file.
* Open the extracted folder.
* Right-click on the `Moodle-AzureAD-Script.ps1` file and select *Properties*.
* Under the *General* tab of the Properties window, check the `Unblock` box next to the *Security* attribute at the bottom.
* Click "OK".
* Copy the directory path of the extracted folder.

### 2. Run PowerShell as Administrator

_From CMD_:

* Launch Command Prompt (cmd).
* Type `powershell -Command "Start-Process PowerShell -Verb RunAs"`.

_From Start Menu_:

* Click Start.
* Type PowerShell.
* Right-click Windows PowerShell.
* Click "Run as Administrator".

### 3. Navigate to the unzipped 'Moodle-AzureAD-Powershell' folder

* Type in `cd ...\...\Moodle-AzureAD-Powershell`, wherein `...\...` refers to the directory where the unzipped folder is located.
  * *Note*: You can paste the directory path copied from Step 1.

### 4. Execute the PowerShell script

* Type `Set-ExecutionPolicy -ExecutionPolicy RemoteSigned -Scope CurrentUser`.
* Type `.\Moodle-AzureAD-Script.ps1`.
* Login to your O365 Adminstrator account from the pop-up window.
* Enter the name of the Azure Application (Ex. Moodle/Moodle plugin).
* Enter the URL of your Moodle server.
* Copy the `Application ID` and `Application Key` generated by the script.  

### 5. Paste the App Credentials to the O365 Moodle Plugin Setup page

* Login to your Moodle server as an adminstratror.
* Go to *Site Administration -> Plugins -> Microsoft 365 Integration*.
* Paste the *Application ID* returned by the script into the `Application ID` field.
* Paste the *Application Key* returned by the script into the `Key` field.
* Click on "Save changes".
* Follow the next steps in the Setup page to successfully configure your Moodle Server with your Microsoft 365 tenant.

## Code of Conduct

This project has adopted the [Microsoft Open Source Code of Conduct](https://opensource.microsoft.com/codeofconduct/). For more information see the [Code of Conduct FAQ](https://opensource.microsoft.com/codeofconduct/faq/) or contact [opencode@microsoft.com](mailto:opencode@microsoft.com) with any additional questions or comments.

## Copyright

&copy; Microsoft, Inc.  Code for this script is licensed under the GPLv3 license.

Any Microsoft trademarks and logos included in these plugins are property of Microsoft and should not be reused, redistributed, modified, repurposed, or otherwise altered or used outside of this plugin.